﻿var respondent = {
    context: $(".respondent-editor"),
    pager: $(".respondentPager"),
    responsesDT: null,
    historyDT: null,
    details: false,
    notesDT: null,
    logsDT: null,
    selectedVariables: null,
    respondentId: $("#RespondentId").val(),
    currentTab: $("#CurrentTab").val(),
    online: false,
    location: null,
    hasUnsavedChanges: false,
    hasNotesChanges: false,
    questions: {},
    initializeResponses: function () {
        $.when(a4.callServerMethod(a4.getProjectAction("GetRespondentResponsesConfiguration", "Data"))).then(function (result) {
            respondent.selectedVariables = result.selectedQuestions;
            responseValidation.initialize(result, false);
            respondent.initializeResponsesTable();
        });
    },
    initializeResponsesTable: function () {
        var columns = [
            { "Name": "QuestionPosition", "Title": "#", "Data": "QuestionPosition" },
            { "Name": "IsMultiMention", "Width": "50px", "Sortable": false, "HideInSelector": true, "Title": "&nbsp;", "Data": function (row) { return row.MatrixLength > 1 ? voxco.icons.getIcon("table") : ""; } },
            { "Data": respondent.renderQuestionTooltip, "Width": "50px", "Tooltip": true },
            { "Name": "Question", "Title": resources.Question, "Data": "Question" },
            { "Name": "Matrix", "Title": resources.Row, "Data": "MatrixFormatValue" },
            { "Name": "Mention", "Title": resources.Mention, "Data": "Mention" },
            { "Name": "Content", "Title": resources.Answer, "Data": "Content", "Width": "30%", "Editable": true },
            { "Name": "OpenEnd", "Title": resources.OpenEnd, "Data": "OpenEnd", "render": function (cellData) { return a4.encodeHtml(cellData); }, "Sortable": false, "Editable": true }];

        var editableDisplayCondition = function (data) {
            return !respondent.online && respondent.location.toLowerCase() == "server" && voxco.security.has('DATA_BROWSE_MODIFY');
        };

        var editableMatrixDisplayCondition = function (data) {
            return editableDisplayCondition(data) && (data == undefined || data.MatrixLength > 1);
        };

        this.responsesDT = $(".h-respondentResponsesTable", this.context).a4datatable({
            advancedFilter: false,
            ajaxAction: a4.getProjectAction("GetResponses", "Data"),
            ajaxParams: { "respondentId": respondent.respondentId, "mergeMentions": true, "variables": respondent.selectedVariables, "preLoadQuestionChoices": true },
            defaultSorting: { Column: "QuestionPosition", Ascending: true },
            columns: columns,
            multiEdit: editableDisplayCondition,
            height: "full",
            stateKey: "RespondentResponses",
            toolBarItems: [
                { "Action": "selectVariables", "Label": resources.SelectQuestions, "DisplayMode": dataTables.itemDisplayMode.always },
                { "Action": "exportExcel", "Label": resources.ExportToExcel, "DisplayMode": dataTables.itemDisplayMode.always }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var caseIds = _.map(rows, function (row) { return row.CaseId });

                switch (action) {
                    case "selectVariables":
                        respondent.showQuestionsSelector();
                        break;

                    case "exportExcel":
                        respondent.exportExcel();
                        break;
                }
            },
            contextMenuItems: [
                { "Action": "addRow", "Label": resources.AddRow, "DisplayCondition": editableMatrixDisplayCondition },
                { "Action": "addMention", "Label": resources.AddMention, "DisplayCondition": editableDisplayCondition },
                { "Action": "clearMention", "Label": resources.Clear, "DisplayCondition": editableDisplayCondition }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "addRow") {
                    respondent.showAddRowDialog(row);
                } else if (action == "addMention") {
                    respondent.addMention(row);
                } else if (action == "clearMention") {
                    respondent.clearMention(row);
                }
            },
            localizableTexts: { "Search": resources.SearchByQuestion },
            loadData: function (evt, data) {
                respondent.questions = data.result.additionalData.QuestionVariables;

                var questionChoices = _.mapObject(respondent.questions, function (val) {
                    return val.Choices;
                });

                responseValidation.initialize({ selectedQuestions: data.result.additionalData.Questions }, false);
                responseValidation.setQuestionCodes(questionChoices);
                responseValidation.setQuestionMask(data.result.additionalData.QuestionMasks);
            },
            draw: function () {
                respondent.pager.removeClass("disabled");
                $(".v-respondentEditorTabs").removeClass("disabled");
            },
            toggleMultiEdit: function (evt, data) {
                respondent.hasUnsavedChanges = false;
            },
            cellCreated: function (evt, data) {
                if (data.fieldName == "Content")
                    responseValidation.verifyRowData(data.flagError, data.row, data.rowIndex, data.fieldName);
            },
            rowUpdated: function (even, data) {
                respondent.hasUnsavedChanges = true;

                if (data.fieldName == "Content" && data.data.Content.length > data.data.CodeWidth) {
                    data.flagError(false);
                    //     respondent.hasUnsavedChanges = false;
                }

                responseValidation.verifyRowData(data.flagError, data.data, data.index, data.fieldName, true, null, false);
            },
            rowsUpdated: function (event, data) {
                var r = data.rows.slice();
                r.forEach(function (v) { delete v.Mask });

                a4.callServerMethod(a4.getProjectAction("UpdateRespondentResponses", "Data"), { responses: r }, function () {
                    data.multiEditSaveCallback();
                    respondent.hasUnsavedChanges = false;
                });
            }
        });
    },
    renderQuestionTooltip: function (rowData) {
        var maxChoices = 10;
        var question = respondent.questions[rowData.Question];

        if (!question)
            return null;

        if (!question.LongLabel && (!question.Choices || question.Choices.length === 0))
            return null;

        var container = $("<div/>");
        var questionDiv = $("<div/>", { class: "tooltip-question-name" });

        questionDiv.append(question.LongLabel || question.Name);
        container.append(questionDiv);

        if (question.Choices) {
            _.each(question.Choices.slice(0, maxChoices), function (choice) {
                var choiceDiv = $("<div/>", { class: "tooltip-choice" });

                var choiceValue = $("<div/>", { class: "tooltip-choice-value" });
                choiceValue.append(choice.Code);
                choiceDiv.append(choiceValue);

                var choiceLabel = $("<div/>", { class: "tooltip-choice-label" });
                choiceLabel.append(choice.Label);                
                choiceDiv.append(choiceLabel);

                container.append(choiceDiv);
            });

            if (question.Choices.length > maxChoices) {
                var choiceDiv = $("<div/>", { class: "tooltip-choice" });
                choiceDiv.append("...");
                container.append(choiceDiv);
            }
        }

        return container.html();
    },
    showAddRowDialog: function (row) {
        var addRowContainer = $("#addRowContainer").clone();
        var container = $('<div id="AddRowPanel" class="flex-container">').append(addRowContainer.html());

        // $(".v-autonumeric", container).autoNumeric({ aPad: false, vMin: '0', vMax: row.MatrixLength, mDec: '0', aSep: '' });
        $(".v-levelRow", container).text(row.MatrixNo);
        $(".v-maximumRow", container).text(row.MatrixLength);

        var validateContentFunction = function () {
            var editor = $("#AddRowPanel");
            var valid = true;

            if ($(".v-row", editor).val() == "" || $(".v-row", editor).val() == "0") {
                a4.showErrorMessage(resources.AttributeEmpty.replace('{0}', $("#rowLabel").text()));
                valid = false;
            }

            return valid;
        }

        var assignResources = {
            "Title": resources.AddRow + " " + row.Question,
            "Message": container
        };

        modalDialog.showConfirmDialog(assignResources, function () {
            a4.callServerMethod(a4.getProjectAction("AddRespondentRow", "Data"), { respondentId: respondent.respondentId, question: row.Question, row: $("#AddRowPanel .v-row").val() },
                function (result) {
                    if (result.success) {
                        respondent.responsesDT.a4datatable("refresh");
                    }
                    else {
                        a4.showErrorMessage(result.message);
                    }
                });
        }, 220, 500, false, null, { validateFunction: validateContentFunction });
    },
    addMention: function (row) {
        var addRowContainer = $("#addMentionContainer").clone();
        var container = $('<div id="AddMentionPanel" class="flex-container">').append(addRowContainer.html());

        $(".v-autonumeric", container).autoNumeric({ aPad: false, vMin: '0', vMax: row.MaxAnswers, mDec: '0', aSep: '' });

        var getQuestion = function () {
            return respondent.getQuestionObject(respondent.respondentId, row.Question, row.Matrix, $(".v-mention", container).val(),
                $(".v-answer", container).val(), $(".v-openEnd", container).val(), row.CodeWidth, false);
        };

        var validateContentFunction = function () {
            var editor = $("#AddMentionPanel");
            var valid = true;

            if ($(".v-mention", editor).val() == "") {
                a4.showErrorMessage(resources.AttributeEmpty.replace('{0}', $("#mentionLabel").text()));
                valid = false;
            }

            var hasErrors = function (hasError) {
                valid = !hasError;
            };

            responseValidation.verifyRowData(hasErrors, getQuestion(), 0, 'Content', true, true, true);

            return valid;
        }

        var assignResources = {
            "Title": resources.AddMentionTitle + " " + row.Question,
            "Message": container
        };

        modalDialog.showConfirmDialog(assignResources, function () {
            a4.callServerMethod(a4.getProjectAction("AddRespondentResponse", "Data"), { response: getQuestion() },
                function (result) {
                    if (result.success) {
                        modalDialog.close();
                        respondent.responsesDT.a4datatable("refresh");
                    }
                    else {
                        a4.showErrorMessage(result.message);
                        return false;
                    }
                });
            return false;
        }, 300, 500, false, null, { validateFunction: validateContentFunction, closeOnConfirm: false });
    },

    getQuestionObject: function (respondentId, question, matrix, mention, content, openEnd, codeWidth, forceOpenEndUpdate) {
        return {
            Id: respondentId,
            Question: question,
            Matrix: matrix,
            Mention: mention,
            Content: content,
            OpenEnd: openEnd,
            CodeWidth: codeWidth,
            HasOpenEnd: forceOpenEndUpdate
        }
    },

    clearMention: function (row) {
        modalDialog.showConfirmDialog(confirmClearResponseResources, function () {
            a4.callServerMethod(a4.getProjectAction("UpdateRespondentResponses", "Data"), { responses: [respondent.getQuestionObject(respondent.respondentId, row.Question, row.Matrix, row.Mention, '', '', row.CodeWidth, true)] },
                function (result) {
                    if (result.success) {
                        respondent.responsesDT.a4datatable("refresh");
                    }
                    else {
                        a4.showErrorMessage(result.message);
                    }
                });

        }, 170, 500, false);
    },

    getRespondentDetails: function (keepUnsavedChanges) {
        if (respondent.details) {
            $(".v-respondentDetails", respondent.context).a4unsavedChanges("destroy");
        }

        a4.callServerMethod(a4.getProjectAction("GetRespondentDetails", "Data"), { "respondentId": respondent.respondentId }, function (result) {
            if (!keepUnsavedChanges)
                $(".v-respondentDetails", this.context).html(result);

            // if the case is online or location is capiproject
            if ($("#Locked").val() == "True") {
                $(".lockable").each(function () {
                    $(this).attr("disabled", true);
                });
            }

            $(".h-respondent-interviewer").a4autocomplete({
                ajaxAction: a4.getProjectAction("GetRespondentInterviewers", "Data", { projectId: $("#ProjectId").val() }),
                valueProperty: "Id",
                labelProperty: "UserName",
                select: function (event, ui) {
                    if (ui && ui.item) {
                        var parent = $(this).closest(".field");
                        $("input[type='hidden']", parent).val(ui.item.Id);
                    }
                }
            });

            $(".h-respondent-nextInterviewer").a4autocomplete({
                ajaxAction: a4.getProjectAction("GetRespondentInterviewers", "Data", { projectId: $("#ProjectId").val() }),
                valueProperty: "Id",
                labelProperty: "UserName",
                select: function (event, ui) {
                    if (ui && ui.item) {
                        var parent = $(this).closest(".field");
                        $("input[type='hidden']", parent).val(ui.item.Id);
                    }
                }
            });

            $(".v-respondentDetails", respondent.context).a4unsavedChanges({
                ignoreDisabledElements: false,
                ignoreHiddenElements: false,
                promptWhenLeavingPage: true,
                change: function (event, data) {
                    if (data.hasChanges || $(".field-validation-error:visible, .input-validation-error:visible").length > 0) {
                        data.buttons.attr("disabled", false);
                    }
                    else {
                        data.buttons.attr("disabled", true);
                    }
                },
                ready: function (event, data) {
                    if ($(".field-validation-error:visible, .input-validation-error:visible").length > 0) {
                        data.buttons.attr("disabled", false);
                    }
                }
            });

            if (!a4.top().hasCAPI) {
                $("#a4sIdSection", respondent.context).hide();
                $(".v-interviewers", respondent.context).hide();
            }

            $(".h-datetimepicker", respondent.context).datetimepicker();
            respondent.pager.removeClass("disabled");
            respondent.details = true;
            $(".v-respondentEditorTabs").removeClass("disabled");
            $("#submit1").attr("disabled", "disabled");

            if (keepUnsavedChanges)
                $(".v-respondentDetails", respondent.context).a4unsavedChanges("change");
        });
    },

    initializeHistoryTable: function () {
        var columns = [{ "Name": "CallNumber", "Title": "#", "Data": "CallNumber", "HideInSelector": true },
        { "Name": "NextCallBack", "Title": resources.NewCallbackDate, "Data": "NextCallBack", "Type": "date" },
        { "Name": "CollectMode", "Title": resources.CollectMode, "Data": "CollectModeValue" },
        { "Name": "InterviewerName", "Title": resources.Interviewer, "Data": "InterviewerName" },
        { "Name": "Phone", "Title": resources.Phone, "Data": "Phone", "Sortable": false },
        { "Name": "DialingMode", "Title": resources.DialingMode, "Data": "DialingMode", "Sortable": false },
        { "Name": "CallDate", "Title": resources.CallDate, "Data": "CallDate", "Type": "date", "Sortable": false },
        { "Name": "CallDuration", "Title": resources.Duration, "Data": "Duration", "Sortable": false },
        { "Name": "TimeSlot", "Title": resources.TimeSlot, "Data": "TimeSlot", "Sortable": false },
        { "Name": "Result", "Title": resources.Result, "Data": "Result", "Sortable": false }];

        this.historyDT = $(".h-respondentHistoryTable", this.context).a4datatable({
            advancedFilter: false,
            ajaxAction: a4.getProjectAction("GetRespondentHistory", "Data"),
            ajaxParams: { "respondentId": respondent.respondentId },
            columns: columns,
            displaySearchBox: false,
            displayColumnSelector: true,
            height: "full",
            draw: function () {
                respondent.pager.removeClass("disabled");
                $(".v-respondentEditorTabs").removeClass("disabled");
            },
            childRow: {
                Render: function (data) {
                    var r = data["Rule"];
                    var header = resources.Rule;
                    var cr = resources.NotAvailable;
                    var sr = resources.NotAvailable;
                    var cnt, cons, callback = "", notes = "";

                    // Rule has Count and Counsecutive, while Extended Rule has Case Result and Results Sequence
                    if (data.RuleId > 0) {
                        cnt = r.Count;
                        cons = a4.boolLabel(r.Consecutive);
                    }
                    else
                        if (data.ExtRuleId > 0) {
                            header = resources.ExtendedRule;
                            r = data["ExtendedRule"];
                            cr = r.LifeState;
                            sr = r.ResultsSequence;
                            cnt = resources.NotAvailable;
                            cons = resources.NotAvailable;
                        }

                    if (data.Notes && data.Notes.Notes)
                        notes = data.Notes.Notes;

                    var html = $("#historyChildRow").clone().html();
                    callback = a4.boolLabel(r.Callback);

                    html = html.replace("{header}", header).replace("{result}", r.Result).replace("{frequency}", cnt).replace("{consecutive}", cons).replace("{case-result}", cr)
                        .replace("{result-sequence}", sr).replace("{callback}", callback).replace("{delay}", r.Delay).replace("{unit}", r.UnitEnum)
                        .replace("{priority}", r.Priority).replace("{counter}", r.Counter || 0).replace("{dialing-mode}", r.DialingModeEnum).replace("{callback-type}", r.CallbackType)
                        .replace("{notes}", notes);

                    return html;
                }
            }
        });
    },

    initializeNotesTable: function () {
        var columns = [{ "Name": "DateTime", "Title": resources.Date, "Data": "DateTime", "Type": "date" },
        { "Name": "InterviewerName", "Title": resources.Interviewer, "Data": "InterviewerName" },
        { "Name": "Question", "Title": resources.Question, "Data": "Question" },
        { "Name": "Matrix", "Title": resources.Row, "Data": "Matrix" },
        { "Name": "RespondentNote", "Title": resources.Notes, "Data": "RespondentNote", "Editable": true }];

        this.notesDT = $(".h-respondentNotesTable", this.context).a4datatable({
            advancedFilter: false,
            ajaxAction: a4.getProjectAction("GetRespondentNotes", "Data"),
            ajaxParams: { "respondentId": respondent.respondentId },
            columns: columns,
            height: "full",
            multiEdit: function (data) {
                return !respondent.online && respondent.location.toLowerCase() == "server" && voxco.security.has('DATA_BROWSE_MODIFY');
            },
            draw: function () {
                respondent.pager.removeClass("disabled");
                $(".v-respondentEditorTabs").removeClass("disabled");
            },
            toggleMultiEdit: function (evt, data) {
                respondent.hasNotesChanges = false;
            },
            rowUpdated: function (even, data) {
                respondent.hasNotesChanges = true;
            },
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getProjectAction("UpdateRespondentNotes", "Data"), { notes: data.rows }, function () {
                    data.multiEditSaveCallback();
                    respondent.hasNotesChanges = false;
                });
            },
            toolBarItems: [
                { "Action": "printNote", "Label": resources.Print, "DisplayMode": dataTables.itemDisplayMode.nonSelected }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;

                switch (action) {
                    case "printNote":
                        modalDialog.showWindow(a4.getProjectAction("RespondentNotesPrint", "Data", { projectId: $("#ProjectId", respondent.context).val(), respondentId: respondent.respondentId }), 620, 500, {});
                        break;
                }
            }
        });
    },

    initializeLogsTable: function () {
        var columns = [{ "Name": "Modified", "Title": resources.ModifiedDate, "Data": "Modified", "Type": "date" },
        { "Name": "ModifiedBy", "Title": resources.ModifiedBy, "Data": "ModifiedBy", "Type": "enum", "EnumType": "ModifiedBy" },
        { "Name": "Source", "Title": resources.Source, "Data": "Source", "Type": "enum", "EnumType": "ModifLogTypeEnum" },
        { "Name": "FieldName", "Title": resources.Property, "Data": "FieldName" },
        { "Name": "FieldValue", "Title": resources.Value, "Data": "FieldValue" },
        { "Name": "OldFieldValue", "Title": resources.PreviousValue, "Data": "OldFieldValue" }];

        this.logsDT = $(".h-respondentLogsTable", this.context).a4datatable({
            advancedFilter: true,
            ajaxAction: a4.getProjectAction("GetRespondentLogs", "Data"),
            ajaxParams: { "respondentId": respondent.respondentId },
            columns: columns,
            height: "full",
            draw: function () {
                respondent.pager.removeClass("disabled");
                $(".v-respondentEditorTabs").removeClass("disabled");
            }
        });
    },

    showQuestionsSelector: function () {
        modalDialog.showWindow(a4.getProjectAction("ResponsesQuestionsSelector", "Data"), 620, 950, {
            beforeClose: function () {
                var questionSelector = $('.fancybox-iframe').contents();
                var confirmed = questionSelector.find(".v-confirmed").val();

                if (confirmed)
                    respondent.selectVariables($('.v-selectedQuestions', questionSelector).val());
            }
        });
    },
    loadTabForRespondent: function (browse, button) {
        var pageIndex = browse.getCurrentPageIndex();
        var respData = browse.datatable.a4datatable("getRowData", pageIndex);

        respondent.respondentId = respData.Id;

        $.when(a4.callServerMethod(a4.getProjectAction("GetRespondent", "Data", { respondentId: respData.Id }))).then(function (result) {

            respondent.online = result.Online;
            respondent.location = result.Location;
            var onDevice = (result.Location.toLowerCase() == "capiclient");

            $("#respondentIdLabel").text(result.Id);
            $("#respondentResultLabel").text(result.CodeVerbose);
            var cbDisplay = !result.CallbackDate ? sharedResources.None : result.CallbackDate;
            $("#respondentCallbackLabel").text(cbDisplay);
            $(".v-status").toggleClass("inactive", result.Online || onDevice);



            $(".v-lockDisplay").toggle(result.Online || onDevice);
            $(".v-respondentNo").text(browse.currentIndex + 1);

            var message = "";

            if (result.Online)
                message = resources.RespondentOnline;
            else if (onDevice)
                message = resources.RespondentOnDevice;

            $(".v-lockMessage").text(message);

            if (respondent.responsesDT) {
                respondent.responsesDT.a4datatable("option", "ajaxParams", { "respondentId": respondent.respondentId });
            }

            if (respondent.historyDT)
                respondent.historyDT.a4datatable("option", "ajaxParams", { "respondentId": respondent.respondentId });

            if (respondent.notesDT) {
                respondent.notesDT.a4datatable("option", "ajaxParams", { "respondentId": respondent.respondentId });
            }

            if (respondent.logsDT)
                respondent.logsDT.a4datatable("option", "ajaxParams", { "respondentId": respondent.respondentId });

            respondent.viewTab(respondent.currentTab);
            button.removeClass("disabled");
        });





    },
    viewTab: function (tabId, keepUnsavedChanges) {
        var container = $(".v-respondentEditorTabs");
        var item = $("ul li[data-editor='" + tabId + "']", container);
        var loaded = item.hasClass("loaded");
        var tabs = item.closest("ul");
        var container = tabs.closest(".v-respondentEditorTabs");

        respondent.currentTab = tabId;

        switch (tabId) {
            case "tabs-1":
                if (keepUnsavedChanges)
                    $(".v-respondentEditorTabs").removeClass("disabled");
                else
                    (loaded) ? respondent.responsesDT.a4datatable("refresh") : respondent.initializeResponses();
                break;

            case "tabs-2":
                (loaded) ? respondent.historyDT.a4datatable("refresh") : respondent.initializeHistoryTable();
                break;

            case "tabs-3":
                respondent.getRespondentDetails(keepUnsavedChanges);
                break;

            case "tabs-4":
                if (keepUnsavedChanges)
                    $(".v-respondentEditorTabs").removeClass("disabled");
                else
                    (loaded) ? respondent.notesDT.a4datatable("refresh") : respondent.initializeNotesTable();
                break;

            case "tabs-5":
                (loaded) ? respondent.logsDT.a4datatable("refresh") : respondent.initializeLogsTable();
                break;
        }

        item.addClass("loaded");

        $(".selected", tabs).removeClass("selected");
        item.addClass("selected");

        $(".v-respondentTab", container).hide();
        $(".v-respondentTab[data-editor='" + tabId + "']", container).show();
    },
    selectVariables: function (variables) {
        respondent.selectedVariables = variables;

        respondent.responsesDT.a4datatable("option", "ajaxParams", { "mergedMentions": true, "variables": variables });
        respondent.responsesDT.a4datatable("refresh", true);

        a4.callServerMethod(a4.getProjectAction("UpdateRespondentResponsesConfiguration", "Data"), { config: variables }, function (result) {
            responseValidation.initialize(result);
        });
    },
    exportExcel: function () {
        var cols = respondent.responsesDT.a4datatable("getVisibleColumns");
        var tableParams = respondent.responsesDT.a4datatable("getTableParams");

        var params = {
            projectId: $("#ProjectId", respondent.context).val(),
            respondentId: respondent.respondentId,
            sortColumn: tableParams.SortColumn,
            sortAscending: tableParams.SortAscending,
            columns: cols.join(),
            variables: respondent.selectedVariables
        };

        a4.showBusyBox();
        a4.callServerMethod(a4.getProjectAction("ExportResponsesExcel", "Data"), params,
            function (result) {
                a4.hideBusyBox();

                window.location = a4.getProjectAction("GetBrowseFile", "Data", { filePath: result, fileName: "RespondentResponses.xlsx" });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
    },
    refreshContent: function () {
        this.responsesDT.a4datatable("refresh");
    },
    checkUnsavedChanges: function (callback) {
        var hasChanges = false;

        if (!voxco.security.has('DATA_BROWSE_MODIFY') || (!respondent.hasUnsavedChanges && !respondent.hasNotesChanges
            && (!respondent.details || !$(".v-respondentDetails", respondent.context).a4unsavedChanges("hasChangedItems")))) {
            a4.top().browse.verifiedBeforeClose = true;

            if (callback)
                callback();
        }
        else {
            hasChanges = true;

            var saveFunction = function () {
                if (respondent.hasUnsavedChanges)
                    respondent.responsesDT.a4datatable("saveChanges");
                else if (respondent.hasNotesChanges)
                    respondent.notesDT.a4datatable("saveChanges");
                else
                    $(".respondent-details input[type=submit]", respondent.context).click();

                a4.top().browse.verifiedBeforeClose = true;

                if (callback)
                    callback();
            };

            var discardFunction = function () {
                a4.top().browse.verifiedBeforeClose = true;

                if (respondent.hasUnsavedChanges)
                    respondent.responsesDT.a4datatable("refresh");
                else if (respondent.hasNotesChanges)
                    respondent.notesDT.a4datatable("refresh");
                else if (respondent.details)
                    $(".v-respondentDetails", respondent.context).a4unsavedChanges("reset");

                if (callback)
                    callback();
            }

            var cancelFunction = function () {
                respondent.viewTab(respondent.currentTab, true);
            };

            modalDialog.showUnsavedChangesDialog(saveFunction, discardFunction, cancelFunction);
        }

        return hasChanges;
    },
    bindEvents: function () {
        $(document).on("click", ".v-respondentEditorTabs:not(.disabled) .tabs ul li", function () {
            var item = $(this);
            item.closest(".v-respondentEditorTabs").addClass("disabled");
            var tabId = item.attr("data-editor");

            var callback = function () {
                respondent.viewTab(tabId);
            };

            respondent.checkUnsavedChanges(callback);
        });

        $(document).on("click", ".respondentPager:not(.disabled) .v-first", function () {
            var browse = a4.parent().browse;

            var callback = function () {
                respondent.pager.addClass("disabled");

                browse.datatable.a4datatable("setCurrentPage", "first", function () {
                    respondent.loadTabForRespondent(browse, $(this));
                });
            };

            respondent.checkUnsavedChanges(callback);
        });

        $(document).on("click", ".respondentPager:not(.disabled) .v-previous", function () {
            var browse = a4.parent().browse;

            var callback = function () {
                if (browse.currentIndex != 0) {
                    respondent.pager.addClass("disabled");

                    if ((browse.currentIndex % browse.pageLength) == 0) {
                        browse.datatable.a4datatable("setCurrentPage", "previous", function () {
                            browse.currentIndex += (browse.pageLength - 1);
                            respondent.loadTabForRespondent(browse, $(this));
                        });
                    }
                    else {
                        browse.currentIndex -= 1;
                        respondent.loadTabForRespondent(browse, $(this));
                    }
                }
            }

            respondent.checkUnsavedChanges(callback);
        });

        $(document).on("click", ".respondentPager:not(.disabled) .v-next", function () {
            var browse = a4.parent().browse;

            var callback = function () {
                if (((browse.currentIndex + 1) % browse.pageLength) == 0) {
                    respondent.pager.addClass("disabled");

                    browse.datatable.a4datatable("setCurrentPage", "next", function () {
                        respondent.loadTabForRespondent(browse, $(this));
                    });
                }
                else if ((browse.currentIndex + 1) != browse.totalRecords) {
                    respondent.pager.addClass("disabled");
                    browse.currentIndex += 1;
                    respondent.loadTabForRespondent(browse, $(this));
                }
            }

            respondent.checkUnsavedChanges(callback);
        });

        $(document).on("click", ".respondentPager:not(.disabled) .v-last", function () {
            var browse = a4.parent().browse;

            var callback = function () {
                respondent.pager.addClass("disabled");

                browse.datatable.a4datatable("setCurrentPage", "last", function () {
                    browse.currentIndex = (browse.totalRecords - 1);
                    respondent.loadTabForRespondent(browse, $(this));
                });
            }

            respondent.checkUnsavedChanges(callback);
        });

        $(document).on("mouseenter", ".v-lockDisplay", function () {
            var tooltip = $(this).next("div.tooltip-content");
            tooltip.css("position", "absolute").show();
        });

        $(document).on("mouseleave", ".v-lockDisplay", function () {
            $(this).next("div.tooltip-content").hide();
        });

        $(document).on("click", ".respondent-details input[type=submit]", function () {
            var button = $(this);
            var model = {};

            $.each($(".v-respondentDetails form").serializeArray(), function (i, element) {
                if (!(element.name in model) || model[element.name] === false) // MVC Checkboxes have an input hidden set to false by default. This code allows the true value to override the false.
                    model[element.name] = element.value;
            });

            a4.callServerMethod(a4.getProjectAction("UpdateRespondentDetails", "Data"), { model: model }, function (result) {
                button.prop("disabled", true);

                var cb = $("#Respondent_CallbackDate").val();

                if (cb == '')
                    cb = sharedResources.None;

                $("#respondentCallbackLabel").html(cb);

                a4.showSuccessMessage(result.message);
            });

            return false;
        });

        $(document).on("click", ".respondent-details .cancel-button", function () {
            respondent.getRespondentDetails(false);
        });

        $(document).on("click", ".close", function () {
            var callback = function () {
                modalDialog.close();
            };

            respondent.checkUnsavedChanges(callback);
        });

        respondent.context.on("click", ".calendarIcon:not(.disabled)", function () {
            $("input.hasDatepicker", $(this).parent()).datepicker('show');
        });
    }
}

$(document).ready(function () {
    if (respondent.context.length > 0) {
        respondent.currentTab = "tabs-" + respondent.currentTab;
        respondent.viewTab(respondent.currentTab);

        var browse = a4.parent().browse;
        $(".v-nbOfRespondents").text(browse.totalRecords);

        respondent.respondentId = $("#RespondentId").val();
        respondent.online = $("#Online").val().toLowerCase() == "true";
        respondent.location = $("#Location").val().toLowerCase();

        respondent.bindEvents();
    }
});

function respondentUnsavedChanged() {
    if (respondent.context.length > 0) {
        respondent.checkUnsavedChanges();
    }
}